local STEM_WIDTH_FRACTION = 0.4

VerticalArrowStamp = function(canvas, x, y1, y2, width, paint)
    if math.abs(y2 - y1) < 1 then
        local y = (y1 + y2) / 2
        local path = Path.line{x1 = x - width, y1 = y, x2 = x + width, y2 = y}
        canvas:setPaint(paint)
            :setThickness(1)
            :stroke(path)
    else
        local headLength
        if y1 < y2 then
            headLength = math.min(width, y2 - y1)
        else
            headLength = math.max(-width, y2 - y1)
        end
        local path = Path.point{x = x, y = y2}
            :addLine{x = x - width, y = y2 - headLength}
            :addLine{x = x - width * STEM_WIDTH_FRACTION, y = y2 - headLength}
            :addLine{x = x - width * STEM_WIDTH_FRACTION, y = y1}
            :addLine{x = x + width * STEM_WIDTH_FRACTION, y = y1}
            :addLine{x = x + width * STEM_WIDTH_FRACTION, y = y2 - headLength}
            :addLine{x = x + width, y = y2 - headLength}
            :closeSubpath()
        canvas:setPaint(paint):fill(path)
    end
end

return VerticalArrowStamp
